#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "Gamma Fit of Raw_Mud C10+ MWs"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    128.00      137.21      137.70     7.0772e-04    7.0520e-04    4.4960e-04    4.4960e-04
    142.00      149.75      151.31     6.3971e-03    6.3308e-03    4.4352e-03    4.4352e-03
    156.30      162.14      163.57     2.3713e-02    2.3505e-02    1.7801e-02    1.7801e-02
    168.48      174.40      175.18     6.0601e-02    6.0331e-02    4.8932e-02    4.8932e-02
    180.30      186.54      185.39     8.7144e-02    8.7688e-02    7.5265e-02    7.5265e-02
    189.79      198.58      195.30     1.3617e-01    1.3846e-01    1.2520e-01    1.2520e-01
    200.33      210.51      205.70     1.6169e-01    1.6547e-01    1.5759e-01    1.5759e-01
    210.92      222.35      217.38     1.9665e-01    2.0115e-01    2.0245e-01    2.0245e-01
    224.15      234.10      231.78     1.8244e-01    1.8426e-01    1.9774e-01    1.9774e-01
    240.88      245.76      248.58     9.8440e-02    9.7324e-02    1.1201e-01    1.1201e-01
    259.16      257.34      265.68     3.0669e-02    2.9706e-02    3.6541e-02    3.6541e-02
    275.16      268.84      278.76     5.9721e-03    5.7596e-03    7.4335e-03    7.4335e-03
    283.24      280.27      285.21     1.7781e-03    1.7473e-03    2.3073e-03    2.3073e-03
    287.44      291.62      291.03     1.9804e-03    1.9844e-03    2.6739e-03    2.6739e-03
    295.67      302.91      297.63     5.3992e-04    5.4949e-04    7.5720e-04    7.5720e-04
    299.88      314.13      305.64     7.9250e-04    8.1450e-04    1.1526e-03    1.1526e-03
    315.54      325.28      321.03     1.4156e-04    1.4344e-04    2.1320e-04    2.1320e-04
    330.82      336.38      335.11     2.8412e-04    2.0002e-05    4.4250e-04    3.1034e-05
    341.89      347.42      346.10     2.0851e-04    4.8201e-06    3.3540e-04    7.7238e-06
    352.90      358.41      357.05     3.1813e-04    1.0898e-06    5.2790e-04    1.8016e-06
    363.86      369.34      370.60     3.3619e-03    2.9025e-07    5.7488e-03    4.9803e-07
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_001_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_001_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Adjusted_Mud C10+ MWs"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    128.00      137.21      137.70     7.1067e-04    7.0814e-04    4.5278e-04    4.5278e-04
    142.00      149.75      151.31     6.4237e-03    6.3572e-03    4.4665e-03    4.4665e-03
    156.30      162.14      163.57     2.3812e-02    2.3603e-02    1.7927e-02    1.7927e-02
    168.48      174.40      175.18     6.0853e-02    6.0582e-02    4.9278e-02    4.9278e-02
    180.30      186.54      185.39     8.7507e-02    8.8054e-02    7.5797e-02    7.5797e-02
    189.79      198.58      195.30     1.3674e-01    1.3904e-01    1.2608e-01    1.2608e-01
    200.33      210.51      205.70     1.6236e-01    1.6616e-01    1.5870e-01    1.5870e-01
    210.92      222.35      217.38     1.9747e-01    2.0199e-01    2.0388e-01    2.0388e-01
    224.15      234.10      231.78     1.8320e-01    1.8503e-01    1.9914e-01    1.9914e-01
    240.88      245.76      248.58     9.8850e-02    9.7730e-02    1.1280e-01    1.1280e-01
    259.16      257.34      265.68     3.0797e-02    2.9830e-02    3.6799e-02    3.6799e-02
    275.16      268.84      278.76     5.9970e-03    5.7836e-03    7.4860e-03    7.4860e-03
    283.24      280.27      285.21     1.7855e-03    1.7546e-03    2.3236e-03    2.3236e-03
    287.44      291.62      291.03     1.9887e-03    1.9927e-03    2.6928e-03    2.6928e-03
    295.67      302.91      297.63     5.4217e-04    5.5178e-04    7.6255e-04    7.6255e-04
    299.88      314.13      305.64     7.9580e-04    8.1789e-04    1.1607e-03    1.1607e-03
    315.54      325.28      321.03     1.4215e-04    1.4404e-04    2.1471e-04    2.1471e-04
    330.82      335.11      335.11     2.0085e-05    2.0085e-05    3.1253e-05    3.1253e-05
    341.89      346.10      346.10     4.8401e-06    4.8401e-06    7.7784e-06    7.7784e-06
    352.90      357.05      357.05     1.0943e-06    1.0943e-06    1.8143e-06    1.8143e-06
    363.86      370.60      370.60     2.9146e-07    2.9146e-07    5.0155e-07    5.0155e-07
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_002_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_002_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Contaminated C11+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    145.30      149.75      150.27     8.1204e-02    8.5126e-02    4.2837e-02    4.5063e-02
    155.88      162.14      161.89     7.1769e-02    8.0155e-02    4.0993e-02    4.5713e-02
    168.22      174.40      174.20     7.2893e-02    6.9577e-02    4.4783e-02    4.2697e-02
    180.43      186.54      186.37     6.9849e-02    6.1731e-02    4.5902e-02    4.0528e-02
    192.52      198.58      198.42     6.4971e-02    5.5343e-02    4.5450e-02    3.8684e-02
    204.51      210.51      210.36     5.7908e-02    4.9933e-02    4.2944e-02    3.7003e-02
    216.40      222.35      222.21     5.4511e-02    4.5251e-02    4.2698e-02    3.5423e-02
    228.20      234.10      233.97     5.0289e-02    4.1145e-02    4.1472e-02    3.3912e-02
    239.90      245.76      245.63     4.3608e-02    3.7510e-02    3.7754e-02    3.2458e-02
    251.53      257.34      257.22     3.4415e-02    3.4271e-02    3.1199e-02    3.1053e-02
    263.07      268.84      268.72     2.8862e-02    3.1369e-02    2.7334e-02    2.9696e-02
    274.53      280.27      280.15     2.6696e-02    2.8759e-02    2.6357e-02    2.8383e-02
    285.92      291.62      291.51     2.4931e-02    2.6405e-02    2.5612e-02    2.7115e-02
    297.25      302.91      302.80     2.1716e-02    2.4274e-02    2.3172e-02    2.5892e-02
    308.50      314.13      314.02     2.0095e-02    2.2341e-02    2.2237e-02    2.4714e-02
    319.69      325.28      325.18     1.8858e-02    2.0583e-02    2.1609e-02    2.3579e-02
    330.82      336.38      336.28     1.8988e-02    1.8983e-02    2.2500e-02    2.2488e-02
    341.89      347.42      347.33     1.7787e-02    1.7523e-02    2.1770e-02    2.1441e-02
    352.90      358.41      358.31     1.5796e-02    1.6190e-02    1.9943e-02    2.0435e-02
    363.86      517.47      517.47     2.0485e-01    2.1598e-01    3.7343e-01    3.9372e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_004_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_004_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set title "Gamma Model of Decontaminated C11+ Log Masses"
show title

$Expt << END
#    Lower     Reported   Calculated    Reported     Calculated     Reported     Calculated
#     MW          MW          MW          Moles         Moles         Mass          Mass
# ----------  ----------  ----------  ------------  ------------  ------------  ------------
    145.30      149.75      150.27     8.6652e-02    8.6621e-02    4.4922e-02    4.5063e-02
    155.88      162.14      161.89     7.5262e-02    8.1562e-02    4.2245e-02    4.5713e-02
    168.22      174.40      174.20     7.3767e-02    7.0799e-02    4.4538e-02    4.2697e-02
    180.43      186.54      186.37     6.8558e-02    6.2815e-02    4.4276e-02    4.0528e-02
    192.52      198.58      198.42     5.9736e-02    5.6315e-02    4.1067e-02    3.8684e-02
    204.51      210.51      210.36     5.0290e-02    5.0810e-02    3.6651e-02    3.7003e-02
    216.40      222.35      222.21     4.4087e-02    4.6046e-02    3.3937e-02    3.5423e-02
    228.20      234.10      233.97     4.0597e-02    4.1868e-02    3.2902e-02    3.3912e-02
    239.90      245.76      245.63     3.9579e-02    3.8169e-02    3.3674e-02    3.2458e-02
    251.53      257.34      257.22     3.4677e-02    3.4873e-02    3.0894e-02    3.1053e-02
    263.07      268.84      268.72     3.0528e-02    3.1920e-02    2.8413e-02    2.9696e-02
    274.53      280.27      280.15     2.8510e-02    2.9265e-02    2.7663e-02    2.8383e-02
    285.92      291.62      291.51     2.6602e-02    2.6868e-02    2.6857e-02    2.7115e-02
    297.25      302.91      302.80     2.3258e-02    2.4700e-02    2.4390e-02    2.5892e-02
    308.50      314.13      314.02     2.1501e-02    2.2733e-02    2.3382e-02    2.4714e-02
    319.69      325.28      325.18     2.0221e-02    2.0945e-02    2.2771e-02    2.3579e-02
    330.82      336.38      336.28     2.0369e-02    1.9317e-02    2.3721e-02    2.2488e-02
    341.89      347.42      347.33     1.9083e-02    1.7831e-02    2.2952e-02    2.1441e-02
    352.90      358.41      358.31     1.6946e-02    1.6474e-02    2.1027e-02    2.0435e-02
    363.86      517.47      517.47     2.1978e-01    2.1978e-01    3.9372e-01    3.9372e-01
END
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set output "Figures/Gamma_005_Moles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
set xlabel "Component Molecular Weight"
set ylabel "Component Moles"
set logscale y
set output "Figures/Gamma_005_LogMoles_1.pdf"
plot [*:*] [*:*] $Expt using 2:4 with points title "Data", $Expt using 3:5 with lines title "Model"
unset logscale y

set output
